<?php
session_start();
$pdo = new PDO("mysql:host=localhost;dbname=your_db;charset=utf8", "db_user", "db_pass");
$userId = $_SESSION['user_id'] ?? $_GET['user'] ?? '';

if (!$userId) {
    die("Missing user ID");
}

$stmt = $pdo->prepare("SELECT points FROM users WHERE user_id = ?");
$stmt->execute([$userId]);
$user = $stmt->fetch();

$points = $user ? $user['points'] : 0;

$stmt = $pdo->prepare("SELECT * FROM conversions WHERE user_id = ? AND created_at > NOW() - INTERVAL 5 MINUTE ORDER BY id DESC LIMIT 1");
$stmt->execute([$userId]);
$conversion = $stmt->fetch();
?>
<!DOCTYPE html>
<html>
<head>
  <title>Your V-Bucks Points</title>
  <style>
    .notify {
      background: #00cc66;
      color: white;
      padding: 10px;
      border-radius: 10px;
      animation: fade 4s ease-in-out;
    }
    @keyframes fade {
      0% {opacity: 0;}
      20% {opacity: 1;}
      80% {opacity: 1;}
      100% {opacity: 0;}
    }
  </style>
</head>
<body>
  <h1>Hello <?= htmlspecialchars($userId) ?>!</h1>
  <p>You have <strong><?= $points ?></strong> points.</p>
  <?php if ($conversion): ?>
    <div class='notify'>🎉 You just earned <?= $conversion['points'] ?> points!</div>
  <?php endif; ?>
</body>
</html>
